/**
 * WooCommerce MailChimp Pro Plugin
 */
var SS_WC_MailChimp_Pro = function($) {

	var $mergeTagsTable;
	var $addMergeTagButton;
	var $deleteMergeTagButtons;
	var $license_field;
	var $activate_button;
	var $deactivate_button;
	var $check_button;
	var message;

	var namespace = 'ss_wc_mailchimp';

	return {
		init: init,
		initProductTab: initProductTab,
	};

	/**
	 * Intialize SS_WC_MailChimp_Pro
	 * @return void
	 */
	function init() {

		initHandles();
		initHandlers();

	} //end function init

	/**
	 * Intialize SS_WC_MailChimp_Pro
	 * @return void
	 */
	function initProductTab() {

		$('.require_subscription input.checkbox').change( function() {
			var $input = $( this );
			var id = $input.attr('id');
			var regex = /ss_wc_mailchimp_(.*)_subscription_sync/g;
			var matches = regex.exec(id);
			var list_id = matches[1];
			var $field = $('p.ss_wc_mailchimp_list_' + list_id + '_expiration_action_field');
			if ( $input.is( ':checked' ) ) {
				$field.show();
			} else {
				$field.hide();
			}
		}).change();

	} //end function initProductTab

	/**
	 * Capture jQuery handles to elements we need
	 * @return void
	 */
	function initHandles() {

		$mergeTagsTable = $('#' + namespace_prefixed('merge_tags_table'));
		$addMergeTagButton = $('#' + namespace_prefixed('add_merge_tag'));
		$deleteMergeTagButtons = $('.' + namespace_prefixed('delete_merge_tag'));
		$license_field = $('#ss_wc_mailchimp_pro_license_key');
		$activate_button = $( '[data-edd_action=activate_license]' );
		$deactivate_button = $( '[data-edd_action=deactivate_license]' );
		$check_button = $( '[data-edd_action=check_license]' );

	} //end function initHandles

	/**
	 * Wire up event handlers
	 * @return void
	 */
	function initHandlers() {

		$addMergeTagButton.click(addMergeTag);
		$deleteMergeTagButtons.click(deleteMergeTag);

		message_fadeout();
		add_status_container();

		// $('button.sswcmcpro-edd-action').click(clicked);
		$( document )
			.on( 'ready keyup', $license_field, key_change )
			.on( 'click', ".sswcmcpro-edd-action", clicked )
			.on( 'sswcmcpro-edd-failed gv-edd-invalid', failed )
			.on( 'sswcmcpro-edd-valid', valid )
			.on( 'sswcmcpro-edd-deactivated', deactivated )
			.on( 'sswcmcpro-edd-inactive gv-edd-other', other );

	} //end function initHandlers

	/**
	 * Hide the "Settings Updated" message after save
	 */
	function message_fadeout() {
		setTimeout( function() {
			$('#message' ).fadeOut();
		}, 2000 );
	}

	function add_status_container() {
		$( SS_WC_MailChimp_Pro_Messages.license_box ).insertAfter( $license_field );
		$( document.body ).trigger( 'init_tooltips' );
	}

	/**
	 * When the license key changes, change the button visibility
	 * @todo refactor- no need having this, plus all the separate methods
	 * @param e
	 */
	function key_change( e ) {

		if (!$license_field) return;
		var license_key = $license_field.val();
		if (!license_key) return;

		var showbuttons = false;
		var hidebuttons = false;

		//buttons.show();

		if (license_key.length > 0) {

			switch ($('#ss_wc_mailchimp_pro_license_key_status').val() ) {
				case 'valid':
					hidebuttons = $('[data-edd_action=activate_license]' );
					showbuttons = $('[data-edd_action=deactivate_license],[data-edd_action=check_license]' );
					break;
				case 'deactivated':
				case 'site_inactive':
				case 'inactive':
				default:
					hidebuttons = $('[data-edd_action=deactivate_license]' );
					showbuttons = $('[data-edd_action=activate_license],[data-edd_action=check_license]' );
					break;
			}
		} else if ( license_key.length === 0 ) {
			hidebuttons = $('[data-edd_action*=_license]');
		}

		// On load, no animation. Otherwise, 100ms
		var speed = ( e.type === 'ready' ) ? 0 : 'fast';

		if( hidebuttons ) {
			hidebuttons.filter(':visible').fadeOut( speed );
		}
		if( showbuttons ) {
			showbuttons.filter( ':hidden' ).removeClass( 'hide' ).hide().fadeIn( speed );
		}
	}

	/**
	 * Show the HTML of the message
	 * @param message HTML for new status
	 */
	function update_status( message ) {
		$( '#woocommerce_mailchimp_pro_license_status_indicator' ).removeClass('loading');
		if ( message !== '' ) {
			$( '#sswcmcpro-edd-status' ).replaceWith( message );
		}
	}

	function set_pending_message( message ) {
		var $sswcmcpro_edd_status = $( '#woocommerce_mailchimp_pro_license_status_indicator' );

		$sswcmcpro_edd_status.html( SS_WC_MailChimp_Pro_Messages.tooltips.validating_license_key.text );
		$( document.body ).trigger( 'init_tooltips' );

		$sswcmcpro_edd_status
			.attr('class', 'sswcmcpro-license-status-indicator loading');
	}

	function clicked( e ) {
		e.preventDefault();

		var $that = $( this );

		var theData = {
			license: $license_field.val(),
			edd_action: $that.attr( 'data-edd_action' ),
			field_id: $that.attr( 'id' ),
		};

		$that.not( $check_button ).addClass('button-disabled');

		wait();

		set_pending_message( $that.attr('data-pending_text') );

		post_data( theData );

	}

	function wait() {
		$( '#mainform')
			.css('cursor', 'wait')
				.find('.button')
				.css('cursor', 'wait')
				.find('input')
				.css('cursor', 'wait');
	}

	function stop() {
		$( '#mainform')
			.css('cursor', 'default')
				.find('.button')
				.css('cursor', 'pointer')
				.find('input')
				.css('cursor', 'pointer');
	}

	/**
	 * Take a string that may be JSON or may be JSON
	 *
	 * @since 1.12
	 * @param {string} string JSON text to attempt to parse
	 * @returns {object} Either JSON-parsed object or object with a message key containing an error message
	 */
	function parse_response_json( string ) {
		var response_object;

		// Parse valid JSON
		try {

			response_object = $.parseJSON( string );

		} catch( exception ) {

			// The JSON didn't parse most likely because PHP warnings.
			// We attempt to strip out all content up to the expected JSON `{"`
			var second_try = string.replace(/((.|\n)+?){"/gm, "{\"");

			try {

				response_object = $.parseJSON( second_try );

			} catch( exception ) {

				console.log( '*** \n*** \n*** Error-causing response:\n***\n***\n', string );

				var error_message = 'JSON failed: another plugin caused a conflict with completing this request. Check your browser\'s Javascript console to view the invalid content.';

				response_object = {
					message: '<div id="gv-edd-status" class="gv-edd-message inline error"><p>' + error_message + '</p></div>'
				};
			}
		}

		return response_object;
	}

	function post_data( theData ) {

		$.post( ajaxurl, {
			'action': 'woocommerce-mailchimp-pro-license',
			'data': theData
		}, function ( response ) {

			var response_object = parse_response_json( response );

			message = response_object.message;

			if( theData.edd_action !== 'check_license' ) {
				$( '#ss_wc_mailchimp_pro_license_key_status' ).val( response_object.license );
				$( '#ss_wc_mailchimp_pro_license_key_response' ).val( JSON.stringify( response_object ) );
				$( document ).trigger( 'sswcmcpro-edd-' + response_object.license, response_object );
			}

			update_status( response_object.message );
			$( document.body ).trigger( 'init_tooltips' );

			stop();
		} );

	}

	function valid( e ) {
		$activate_button
			.fadeOut( 'medium', function () {
				$activate_button.removeClass( 'button-disabled' );
				$deactivate_button.fadeIn().css( "display", "inline-block" );
			} );
	}

	function failed( e ) {
		$deactivate_button.removeClass( 'button-disabled' );
		$activate_button.removeClass( 'button-disabled' );
	}

	function deactivated( e ) {
		$deactivate_button
			.css('min-width', function() {
				return $(this ).width();
			})
			.fadeOut( 'medium', function () {
				$deactivate_button.removeClass( 'button-disabled' );
				$activate_button.fadeIn(function() {
					$(this).css( "display", "inline-block" );
				});
			} );

	}

	function other( e ) {
		$deactivate_button.fadeOut( 'medium', function () {
			$activate_button
				.removeClass( 'button-disabled' )
				.fadeIn()
				.css( "display", "inline-block" );
		} );
	}

	/**
	 * Add a merge tag row to the merge tags table
	 * @return void
	 */
	function addMergeTag() {

		$lastMergeTagRow = $mergeTagsTable.find('tbody>tr:last');

		// Get last field id
		var current_id = ($lastMergeTagRow.attr('id').replace('ss_wc_mailchimp_optional_merge_tags_', ''));

		$lastMergeTagRow.clone(true).insertAfter($mergeTagsTable.find('tbody>tr:last'));

		$lastMergeTagRow.each( function() {

			// Change ids
			var next_id = parseInt(current_id, 10) + 1;
			$(this).attr('id', 'ss_wc_mailchimp_merge_tag_'+next_id);
			$(this).find(':input').each( function() {
				if ($(this).is('input')) {
					$(this).attr('id', 'ss_wc_mailchimp_merge_tag_'+next_id);
					// $(this).attr('name', 'woochimp_options[field_names]['+page+']['+next_id+'][name]');
					$(this).val('');
				}
				else if ($(this).is('select')) {
					if ($(this).hasClass('woochimp_name_select')) {
						$(this).attr('id', 'ss_wc_mailchimp_mailchimp_merge_tag_'+next_id);
						// $(this).attr('name', 'woochimp_options[field_names]['+page+']['+next_id+'][name]');
						$(this).val('');
					}
					else if (jQuery(this).hasClass('woochimp_tag_select')) {
						$(this).attr('id', 'ss_wc_mailchimp_woocommerce_field_'+next_id);
						// $(this).attr('name', 'woochimp_options[field_names]['+page+']['+next_id+'][tag]');
						$(this).val('');
					}
				}
			});


			$('#ss_wc_mailchimp_mailchimp_merge_tag_'+next_id).select2('destroy').select2();
			$('#ss_wc_mailchimp_woocommerce_field_'+next_id).select2('destroy').select2();

			// Enable fields not selected. Disable fields selected.
			enableDisableSelects();

		});

	} //end function addMergeTag

	/**
	 * Delete a merge tag row from the merge tags table
	 * @return void
	 */
	function deleteMergeTag(e) {

		e.preventDefault();

		// Do not remove the last set - reset field values instead
		if ($(this).parent().parent().parent().children('.optional').length === 1) {
			$(this).parent().parent().find(':input').each( function() {
				$(this).val('');
			});
		}
		else {
			$(this).parent().parent().remove();
		}

		// Enable fields not selected. Disable fields selected.
		enableDisableSelects();

	} //end function deleteMergeTag

	/**
	 * Enables fields not selected. Disables fields selected.
	 */
	function enableDisableSelects() {

		var all_selected = {};

		// Get all selected fields
		$mergeTagsTable.find('select').each( function() {
			if ($(this).find(':selected').length > 0 && $(this).find(':selected').val() !== '') {
				all_selected[$(this).prop('id')] = $(this).find(':selected').val();
			}
		});

		// Reinit select2 fields
		$mergeTagsTable.find('select').each( function() {

			if (Object.keys(all_selected).length !== 0) {

				for (var prop in all_selected) {

					if (prop !== $(this).prop('id')) {

						// Disable
						$(this).find('option[value="'+all_selected[prop]+'"]').prop('disabled', true);
					}


					// Enable previously disabled values if they are available now
					$(this).find(':disabled').each( function() {

						// Check if such disabled property exists within selected properties
						var option_value = $(this).val();
						var exists = false;

						for (var proper in all_selected) {
							if (all_selected[proper] === option_value) {
								exists = true;
								break;
							}
						}

						// Remove if it does not exist
						if (!exists) {
							$(this).removeAttr('disabled');
						}

					});

				}
			}
			else {
				// Enable all properties on all fields if there's only one left
				$(this).find(':disabled').each( function() {
					$(this).removeAttr('disabled');
				});
			}

		});

	} //end function enableDisableSelects

	/**
	 * Helper function for generating a namespace-prefixed string
	 * @param  {string} suffix [The suffix to prefix with the namespace]
	 * @return {string}        [The namespace-prefixed string]
	 */
	function namespace_prefixed( suffix ) {

		return namespace + '_' + suffix;

	} //end function namespace_prefixed

}(jQuery);
