<?php

/**
 * WooCommerce MailChimp Pro plugin migrator class
 */
final class SS_WC_MailChimp_Pro_Migrator {

	const VERSION_KEY = 'ss_wc_mailchimp_pro_version';

	protected static $versions = array(
		'2.3.0',
		'2.3.1',
		'2.3.2',
	);

	public static function migrate( $target_version ) {

		$current_version = get_option( self::VERSION_KEY );

		if ( ! $current_version ) {
			// This is a new install, so no need to migrate
			update_option( self::VERSION_KEY, $target_version );
			return;
		}

		if ( $current_version !== $target_version ) {

			require_once( SS_WC_MAILCHIMP_PRO_DIR . 'includes/migrations/class-ss-wc-mailchimp-pro-migration.php' );

			$start = array_search( $current_version, self::$versions );

			if ( ! $start ) {
				update_option( self::VERSION_KEY, $target_version );
				return;
			}

			for ($start; $start < count(self::$versions) - 1; $start++) {
				$next = $start + 1;
				$current_version = self::$versions[$start];
				$next_version = self::$versions[$next];

				if ( file_exists( SS_WC_MAILCHIMP_PRO_DIR . "includes/migrations/class-ss-wc-mailchimp-pro-migration-from-$current_version-to-$next_version.php" ) ) {

					do_action( 'sswcmc_log', 'Pro: Migrating from ' . $current_version . ' to ' . $target_version );

					require_once( SS_WC_MAILCHIMP_PRO_DIR . "includes/migrations/class-ss-wc-mailchimp-pro-migration-from-$current_version-to-$next_version.php" );

					$migration_name = 'SS_WC_MailChimp_Pro_Migration_From_'. self::clean_version( $current_version ) .'_To_'. self::clean_version( $next_version );

					$migration = new $migration_name( $current_version, $next_version );
					if ( $migration->up() ) {
						// Update the current plugin version
						update_option( self::VERSION_KEY, $next_version );
						do_action( 'sswcmc_log', 'Pro: Finished Migrating from ' . $current_version . ' to ' . $target_version );
					}

				} else {
					// Update the current plugin version
					do_action( 'sswcmc_log', 'Pro: No migration found from ' . $current_version . ' to ' . $next_version . '. Setting current version to: ' . $next_version );

					update_option( self::VERSION_KEY, $next_version );
				}
			}

		}

	}

	private static function clean_version( $version ) {
		return str_replace( '.', '_', $version );
	}

}
