<?php

final class SS_WC_MailChimp_Pro_Migration_From_2_3_1_To_2_3_2 extends SS_WC_MailChimp_Pro_Migration {

	public function __construct( $current_version, $target_version ) {
		parent::__construct( $current_version, $target_version );
	}

	/**
	 * [up description]
	 * @return [type] [description]
	 */
	public function up() {

		try {

			// Convert tags to tag IDs on products

			global $wpdb;
			$results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}postmeta WHERE meta_key = '_ss_wc_mailchimp_list_tags'" );

			foreach( $results as $result ) {
				$post_meta = unserialize( $result->meta_value );

				if ( is_array( $post_meta ) && ! empty( $post_meta ) ) {

					foreach ( $post_meta as $list_id => $existing_tags ) {

						if ( ! empty( $list_id ) ) {
							$current_tags = $this->mailchimp->get_tags( $list_id );

							if ( ! empty( $current_tags ) ) {

								// Let's correct the tags
								$new_tags = array_filter( $current_tags, function ( $tag_name ) use ( $existing_tags ) {
									return in_array( $tag_name, $existing_tags );
								});

								$new_tags = array_map( 'strval', array_keys( $new_tags ) );

								$post_meta[$list_id] = $new_tags;

							}
						}
					}

					// Update the tag post meta
					update_post_meta( $result->post_id, $result->meta_key, $post_meta );

				}
			}

		} catch (Exception $e) {
			do_action( 'sswcmc_log', 'Error Migrating from ' . $this->current_version . ' to ' . $this->target_version . ': ' . $e->getMessage() );
			return false;
		}

		return true;

	}

	/**
	 * [down description]
	 * @return [type] [description]
	 */
	public function down() {

		throw new Exception('Cannot rollback to versions prior to 2.3.2');

	}

}
