<?php
/**
 * Plugin Name: WooCommerce Mailchimp Pro
 * Plugin URI: https://www.saintsystems.com/products/woocommerce-mailchimp-pro/
 * Description: WooCommerce Mailchimp Pro provides advanced Mailchimp integration for WooCommerce.
 * Author: Saint Systems
 * Author URI: https://www.saintsystems.com
 * Version: 2.4.4
 * WC tested up to: 5.3.0
 * Text Domain: woocommerce-mailchimp
 * Domain Path: languages
 *
 * Copyright: © 2019 Saint Systems
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

/** If this file is called directly, abort. */
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

/** Constants */

/**
 * Full path to the WooCommerce MailChimp Pro file
 * @define "SS_WC_MAILCHIMP_PRO_FILE" "./woocommmerce-mailchimp-pro.php"
 */
define( 'SS_WC_MAILCHIMP_PRO_FILE', __FILE__ );

define( 'SS_WC_MAILCHIMP_PRO_DIR', plugin_dir_path( SS_WC_MAILCHIMP_PRO_FILE ) );

/**
 * The main plugin class (SS_WC_MailChimp_Pro_Plugin)
 */
require_once( 'includes/class-ss-wc-mailchimp-pro-plugin.php' );

/** Register hooks that are fired when the plugin is activated and deactivated. */
if ( is_admin() ) {
	register_activation_hook( SS_WC_MAILCHIMP_PRO_FILE, array( 'SS_WC_MailChimp_Pro_Plugin', 'activate' ) );
	register_deactivation_hook( SS_WC_MAILCHIMP_PRO_FILE, array( 'SS_WC_MailChimp_Pro_Plugin', 'deactivate' ) );
}

//add_action( 'plugins_loaded', array( 'SS_WC_MailChimp_Plugin', 'instance' ), 0 );
function SSWCMCPRO() {
	return SS_WC_MailChimp_Pro_Plugin::get_instance();
}

// Get WooCommerce Mailchimp Running.
add_action( 'plugins_loaded', 'SSWCMCPRO', 30 );
