<?php

abstract class SS_WC_MailChimp_Pro_Migration {

	protected $mailchimp;

	protected $settings;

	protected $namespace = 'ss_wc_mailchimp_pro';

	protected $current_version;
	protected $target_version;

	protected $setting_keys;

	public function __construct( $current_version, $target_version ) {

		$this->setting_keys = array(
			'always_subscribe_to_product_lists',
			'license_key',
			'version',
		);

		$this->settings = array();

		$this->current_version = $current_version;
		$this->target_version = $target_version;

		if ( ! $this->load_settings() ) return;

		if ( empty( $this->settings['license_key'] ) ) return;

		require_once( SS_WC_MAILCHIMP_DIR . 'includes/class-ss-wc-mailchimp.php' );
		$this->mailchimp = new SS_WC_MailChimp( get_option( 'ss_wc_mailchimp_api_key' ) );
	}

	/**
	 * [save_settings description]
	 * @return [type] [description]
	 */
	public function load_settings() {

		foreach ( $this->setting_keys as $key ) {
			$this->settings[ $key ] = get_option( $this->namespace_prefixed( $key ) );
		}

		return true;

	}

	/**
	 * [save_settings description]
	 * @return [type] [description]
	 */
	public function save_settings() {

		foreach ( $this->settings as $key => $value ) {
			update_option( $this->namespace_prefixed( $key ), $value );
		}

	}

	protected function namespace_prefixed( $suffix ) {
		return $this->namespace . '_' . $suffix;
	}

}
